/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.dataconnect;

import com.belenus.dataconnect.DatabaseConnector;
import com.belenus.dataconnect.Identifiable;
import com.belenus.dataconnect.Transaction;
import com.belenus.dataconnect.TransactionException;
import com.belenus.util.Configurator;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class DatabaseManager
extends DatabaseConnector {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$dataconnect$DatabaseManager == null ? (class$com$belenus$dataconnect$DatabaseManager = DatabaseManager.class$("com.belenus.dataconnect.DatabaseManager")) : class$com$belenus$dataconnect$DatabaseManager));
    private static Hashtable s_databaseManagerMap = new Hashtable(89);
    private static ArrayList s_databaseManagers = new ArrayList();
    private Hashtable m_transactionMap = new Hashtable(89);
    static /* synthetic */ Class class$com$belenus$dataconnect$DatabaseManager;

    protected DatabaseManager(Configurator configurator, File workingDirectoryPath) throws IllegalAccessException, InstantiationException, NamingException, SQLException {
        super(configurator, workingDirectoryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseManager getDatabaseManager(Configurator configurator, File workingDirectoryPath) throws IllegalAccessException, InstantiationException, NamingException, SQLException {
        ArrayList arrayList = s_databaseManagers;
        synchronized (arrayList) {
            DatabaseManager newDatabaseManager = new DatabaseManager(configurator, workingDirectoryPath);
            for (int databaseManagersIndex = 0; databaseManagersIndex < s_databaseManagers.size(); ++databaseManagersIndex) {
                DatabaseManager databaseManager = (DatabaseManager)s_databaseManagers.get(databaseManagersIndex);
                if (!databaseManager.equals(newDatabaseManager)) continue;
                logger.info((Object)("Using preinitialized DatabaseManager - now in use: " + s_databaseManagers.size()));
                return databaseManager;
            }
            s_databaseManagers.add(newDatabaseManager);
            logger.info((Object)("Using new DatabaseManager - now in use: " + s_databaseManagers.size()));
            return newDatabaseManager;
        }
    }

    public static DatabaseManager getDatabaseManager() {
        DatabaseManager databaseManager = (DatabaseManager)s_databaseManagerMap.get(Thread.currentThread());
        if (databaseManager == null) {
            throw new IllegalStateException("DatabaseManager not set.");
        }
        return databaseManager;
    }

    public static void setDatabaseManager(DatabaseManager databaseManager) {
        s_databaseManagerMap.put(Thread.currentThread(), databaseManager);
    }

    public static void unsetDatabaseManager() {
        s_databaseManagerMap.remove(Thread.currentThread());
    }

    public Transaction startTransaction() {
        Thread currentThread = Thread.currentThread();
        Hashtable hashtable = this.m_transactionMap;
        synchronized (hashtable) {
            Transaction transaction = (Transaction)this.m_transactionMap.get(currentThread);
            if (transaction == null) {
                transaction = new Transaction(this);
                this.m_transactionMap.put(currentThread, transaction);
                return transaction;
            }
            throw new TransactionException("Thread has transaction already assigned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTransaction() {
        Thread currentThread = Thread.currentThread();
        Hashtable hashtable = this.m_transactionMap;
        synchronized (hashtable) {
            return this.m_transactionMap.containsKey(currentThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getTransaction() {
        Thread currentThread = Thread.currentThread();
        Hashtable hashtable = this.m_transactionMap;
        synchronized (hashtable) {
            Transaction transaction = (Transaction)this.m_transactionMap.get(currentThread);
            if (transaction == null) {
                throw new TransactionException("Transaction either not started or already closed");
            }
            return transaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTransaction() {
        Thread currentThread = Thread.currentThread();
        Hashtable hashtable = this.m_transactionMap;
        synchronized (hashtable) {
            Transaction transaction = (Transaction)this.m_transactionMap.get(currentThread);
            if (transaction == null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishTransaction() {
        Thread currentThread = Thread.currentThread();
        Hashtable hashtable = this.m_transactionMap;
        synchronized (hashtable) {
            Transaction transaction = (Transaction)this.m_transactionMap.get(currentThread);
            if (transaction == null) {
                throw new TransactionException("Transaction either not started or already closed");
            }
            this.m_transactionMap.remove(currentThread);
            transaction.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortTransaction() {
        Thread currentThread = Thread.currentThread();
        Hashtable hashtable = this.m_transactionMap;
        synchronized (hashtable) {
            Transaction transaction = (Transaction)this.m_transactionMap.get(currentThread);
            if (transaction != null) {
                this.m_transactionMap.remove(currentThread);
                transaction.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() {
        Thread currentThread = Thread.currentThread();
        Hashtable hashtable = this.m_transactionMap;
        synchronized (hashtable) {
            Transaction transaction = (Transaction)this.m_transactionMap.get(currentThread);
            if (transaction == null) {
                throw new TransactionException("Transaction either not started or already closed");
            }
            return transaction.getConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshConnection() {
        Thread currentThread = Thread.currentThread();
        Hashtable hashtable = this.m_transactionMap;
        synchronized (hashtable) {
            Transaction transaction = (Transaction)this.m_transactionMap.get(currentThread);
            if (transaction == null) {
                throw new TransactionException("Transaction either not started or already closed");
            }
            transaction.refreshConnection();
        }
    }

    public void finishLiberatedConnection(Connection connection) {
        this.releaseConnection(connection);
    }

    public void abortLiberatedConnection(Connection connection) {
        this.releaseConnection(connection);
    }

    public Connection getLiberatedConnection() {
        try {
            Connection liberatedConnection = this.provideConnection();
            return liberatedConnection;
        }
        catch (SQLException sqlException) {
            throw new TransactionException("Cannot get connection (cannot connect to database): " + sqlException.getMessage(), sqlException);
        }
    }

    public void close(Statement statement, ResultSet resultSet, boolean working) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sqlException) {
            // empty catch block
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sqlException) {
            // empty catch block
        }
        if (!working) {
            this.refreshConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAvailbility() throws Throwable {
        try {
            this.startTransaction();
            this.getConnection();
            this.refreshConnection();
            Connection connection = this.getConnection();
            Statement statement = connection.createStatement();
            this.close(statement, null, true);
        }
        finally {
            this.finishTransaction();
        }
    }

    public static StringBuffer pick(String tablecolumn, Collection identifiers) {
        if (identifiers.size() == 0) {
            return new StringBuffer("FALSE");
        }
        if (identifiers.size() == 1) {
            Iterator identifiersIterator = identifiers.iterator();
            return DatabaseManager.pick(tablecolumn, identifiersIterator.next());
        }
        StringBuffer idListString = new StringBuffer(tablecolumn.length() + identifiers.size() * 36 + 20);
        idListString.append(tablecolumn).append(" IN (");
        Iterator identifiersIterator = identifiers.iterator();
        while (identifiersIterator.hasNext()) {
            Object identifier = identifiersIterator.next();
            if (identifier == null) {
                idListString.append("NULL");
            } else if (identifier instanceof String) {
                idListString.append('\'').append((String)identifier).append('\'');
            } else if (identifier instanceof StringBuffer) {
                idListString.append('\'').append(identifier.toString()).append('\'');
            } else if (identifier instanceof Identifiable) {
                idListString.append('\'').append(((Identifiable)identifier).getIdentifier()).append('\'');
            } else {
                throw new IllegalArgumentException("Identifier is not of a allowed type. It is " + identifier.getClass().getName());
            }
            if (!identifiersIterator.hasNext()) continue;
            idListString.append(", ");
        }
        idListString.append(")");
        return idListString;
    }

    public static StringBuffer pick(String tablecolumn, Object identifier) {
        if (identifier == null) {
            return new StringBuffer(tablecolumn).append(" IS NULL");
        }
        if (identifier instanceof String) {
            return new StringBuffer(tablecolumn).append("='").append((String)identifier).append('\'');
        }
        if (identifier instanceof StringBuffer) {
            return new StringBuffer(tablecolumn).append("='").append(((StringBuffer)identifier).toString()).append('\'');
        }
        if (identifier instanceof Identifiable) {
            return new StringBuffer(tablecolumn).append("='").append(((Identifiable)identifier).getIdentifier()).append('\'');
        }
        if (identifier instanceof Collection) {
            return DatabaseManager.pick(tablecolumn, (Collection)identifier);
        }
        throw new IllegalArgumentException("Identifier is not of a allowed type. It is " + identifier.getClass().getName());
    }

    public static StringBuffer pickDistinct(String tablecolumn, Collection identifiers) {
        if (identifiers.size() == 0) {
            return new StringBuffer("FALSE");
        }
        if (identifiers.size() == 1) {
            Iterator identifiersIterator = identifiers.iterator();
            return DatabaseManager.pick(tablecolumn, identifiersIterator.next());
        }
        HashSet<String> identifiersSet = new HashSet<String>();
        StringBuffer idListString = new StringBuffer(tablecolumn.length() + identifiers.size() * 36 + 20);
        idListString.append(tablecolumn).append(" IN (");
        Iterator identifiersIterator = identifiers.iterator();
        boolean alreadyAddedOne = false;
        while (identifiersIterator.hasNext()) {
            Object identifier = identifiersIterator.next();
            if (identifier == null) {
                if (!identifiersSet.contains(null)) {
                    identifiersSet.add(null);
                    if (alreadyAddedOne) {
                        idListString.append(", ");
                    }
                    idListString.append("NULL");
                }
            } else {
                String identifierString;
                if (identifier instanceof String) {
                    identifierString = (String)identifier;
                } else if (identifier instanceof StringBuffer) {
                    identifierString = identifier.toString();
                } else if (identifier instanceof Identifiable) {
                    identifierString = ((Identifiable)identifier).getIdentifier();
                } else {
                    throw new IllegalArgumentException("Identifier is not of a allowed type. It is " + identifier.getClass().getName());
                }
                identifierString = identifierString.intern();
                if (!identifiersSet.contains(identifierString)) {
                    identifiersSet.add(identifierString);
                    if (alreadyAddedOne) {
                        idListString.append(", ");
                    }
                    idListString.append('\'').append(identifierString).append('\'');
                }
            }
            alreadyAddedOne = true;
        }
        idListString.append(")");
        return idListString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

